import QtQuick 2.12

Item {
    id: root
    implicitHeight: 16
    implicitWidth: label.paintedWidth + 8
    signal clicked()
    property alias text: label.text
    property alias radius: background.radius
    property string backgroundColor: "grey"
    property string textColor: "white"
    Rectangle {
        id: background
        color: root.enabled ? ma.pressed ? Qt.lighter(backgroundColor) : backgroundColor : Qt.darker(backgroundColor)
        border.color: Qt.darker(backgroundColor)
        border.width: 1
        anchors.fill: parent
        Text {
            id: label
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.verticalCenter: parent.verticalCenter
            color: root.enabled ? textColor: Qt.darker(textColor)
            font.pixelSize: parent.height * 0.8
            text: "Button"
        }
        MouseArea {
            id: ma
            anchors.fill: parent
            onClicked: root.clicked()
        }
    }
}
